/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.beans;

import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.beans.HasProperty;
import org.hamcrest.beans.HasPropertyWithValueTest;
import org.hamcrest.core.IsNot;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HasPropertyTest
extends AbstractMatcherTest {
    private final HasPropertyWithValueTest.BeanWithoutInfo bean = new HasPropertyWithValueTest.BeanWithoutInfo("a bean");

    @Override
    protected Matcher<?> createMatcher() {
        return HasProperty.hasProperty((String)"irrelevant");
    }

    public void testReturnsTrueIfPropertyExists() {
        MatcherAssert.assertThat((Object)this.bean, (Matcher)HasProperty.hasProperty((String)"writeOnlyProperty"));
    }

    public void testReturnsFalseIfPropertyDoesNotExist() {
        Matcher hasProperty = HasProperty.hasProperty((String)"aNonExistentProp");
        MatcherAssert.assertThat((Object)this.bean, (Matcher)IsNot.not((Matcher)hasProperty));
        HasPropertyTest.assertMismatchDescription("no \"aNonExistentProp\" in <[Person: a bean]>", hasProperty, this.bean);
    }

    public void testDescribeTo() {
        HasPropertyTest.assertDescription("hasProperty(\"property\")", HasProperty.hasProperty((String)"property"));
    }
}

